﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VeteransAffairs.Registries.BusinessAHOBPR;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class RegistrantDeploymentUtilities : AHOBPRBaseBO
    {
        const string UNIQUEQUESTIONID = "1.2.B";
        string connectionInfo;
        List<int> questionIds = new List<int>();
        public RegistrantDeploymentUtilities() { }
        public RegistrantDeploymentUtilities(string dbConnection)
        {
            connectionInfo = dbConnection;
            PopulateStdFormQuestionIds();
        }

        private void PopulateStdFormQuestionIds()
        {
            using (var db = GetLocalContext(connectionInfo))
            {
                questionIds = db.STD_FORM_QUESTIONs.Where(fq => fq.FORM_QUESTION_UNIQUE_ID == UNIQUEQUESTIONID).Select(r => r.STD_FORM_QUESTION_ID).ToList();
            }
        }
        public void SetDeploymentStage(REGISTRANT_DEPLOYMENT deployment, int? registrantStatusId)
        {
            if (deployment.STD_DEPLOYMENT_STAGE_ID == (int)Enums.DeploymentStage.NotSet || deployment.STD_DEPLOYMENT_STAGE_ID == 0)
            {
                deployment.STD_DEPLOYMENT_STAGE_ID = (deployment.IS_ELIGIBLE_FLAG == true) ? (int)Enums.DeploymentStage.New : (int)Enums.DeploymentStage.NotEligible;
            }
            else
            {
                //CHECK REG STATUS
                if (registrantStatusId.HasValue)
                {
                    if (registrantStatusId == (int)Enums.RegistrantStatus.Participant)
                    {
                        VerifyDeploymentStage(deployment);
                    }
                }
            }
        }
        public void SetDeploymentStage(REGISTRANT_DEPLOYMENT deployment, int? registrantStatusId, bool hasDeploymentsInQuestionnaire)
        {
            if (deployment.STD_DEPLOYMENT_STAGE_ID == (int)Enums.DeploymentStage.NotSet || deployment.STD_DEPLOYMENT_STAGE_ID == 0)
            {
                deployment.STD_DEPLOYMENT_STAGE_ID = (deployment.IS_ELIGIBLE_FLAG == true) ? (int)Enums.DeploymentStage.New : (int)Enums.DeploymentStage.NotEligible;
            }
            else
            {
                //CHECK REG STATUS
                if (registrantStatusId.HasValue)
                {
                    if (registrantStatusId == (int)Enums.RegistrantStatus.Participant)
                    {
                        VerifyDeploymentStage(deployment, hasDeploymentsInQuestionnaire);
                    }
                }
            }
        }
        public void VerifyDeploymentStage(REGISTRANT_DEPLOYMENT deployment)
        {
            VerifyDeploymentStage(deployment, false);
        }
        public void VerifyDeploymentStage(REGISTRANT_DEPLOYMENT deployment, bool hasDeploymentsInJson)
        {
            //Works for any deployment that comes through THE FIRST TIME
            //IF deployment
            var hasDeploymentsInQuestionnaire = hasDeploymentsInJson |= DoesDeploymentHaveFormResponse(deployment);
            if (deployment.USER_VERIFIED_FLAG == true && deployment.IS_ELIGIBLE_FLAG == true)
            {
                if (hasDeploymentsInQuestionnaire)
                {
                    deployment.STD_DEPLOYMENT_STAGE_ID = (int)Enums.DeploymentStage.Verified;
                }
            }
            else if (deployment.USER_VERIFIED_FLAG == false && deployment.IS_ELIGIBLE_FLAG == true)
            {
                deployment.STD_DEPLOYMENT_STAGE_ID = (int)Enums.DeploymentStage.Refuted;
            }
        }
        public bool DoesDeploymentHaveFormResponse(REGISTRANT_DEPLOYMENT deployment)
        {
            bool result = false;
            using (var db = GetLocalContext(connectionInfo))
            {
                result = db.FORM_RESPONSE_QUESTIONs.Any(f => f.REGISTRANT_DEPLOYMENT_ID == deployment.REGISTRANT_DEPLOYMENT_ID && questionIds.Contains(f.STD_FORM_QUESTION_ID));
            }
            return result;
        }
    }
}
